\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{IIENP}[ Modelo do II Encontro Nacional do PROFMAT]
\LoadClass{sciposter}

%
% pacotes necessarios
%
\RequirePackage{graphicx}
\RequirePackage{multicol}
\RequirePackage[export]{adjustbox}
\RequirePackage[portuguese]{babel}

%
% define as variaveis do cabecalho
%
\def\titulo#1{\def\@titulo{#1}}
\def\autor#1{\def\@autor{#1}}
\def\email#1{\def\@email{#1}}
\def\universidade#1{\def\@universidade{#1}}

%
% comando para gerar o cabecalho
%
\newcommand{\cabecalho}{%
    \begin{center}
        {\Huge II Encontro Nacional do PROFMAT - Campo Grande, MS.} \\
    \end{center}
    \begin{minipage}{0.8\textwidth}
        {\huge\@titulo} \\
        \vspace{0.1cm}

        {\Large\@autor} \\
        \@universidade \\
        \@email
    \end{minipage}
    \begin{minipage}{0.2\textwidth}
        \includegraphics[scale=.57]{modelo-poster/enp2025.jpeg}
         \end{minipage}
}

%
% comando para gerar o corpo do documento separado em colunas
%
\newcommand{\colunas}[1]{%}
    \begin{multicols}{2}
        #1
    \end{multicols}
}

%
% comando para gerar o rodape do documento
%
\newcommand{\rodape}{%

    \vfill{}
    \begin{figure}[h]
        \centering
        \includegraphics[width=\textwidth]{apoio.jpeg}
    \end{figure}
}

%
% comandos para declarar figuras
%
\newcommand{\figura}[3]{%
    \begin{figure}[h]
        \centering
        \includegraphics[scale=#1]{#2}
        \caption{#3}
    \end{figure}
}

\newcommand{\figuras}[3]{%
    \begin{figure}[h]
        \includegraphics[width=0.49\textwidth]{#1}
        \includegraphics[width=0.49\textwidth]{#2}
        \caption{#3}
    \end{figure}
}
