\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{enp}

\LoadClass[11pt, a4paper, twoside]{article}
\setlength{\textwidth}{15cm}
\setlength{\textheight}{21.0cm}
\setlength{\topmargin}{0cm}
\setlength{\oddsidemargin}{0.65cm}
\setlength{\evensidemargin}{0.65cm}

\renewenvironment{abstract}
{\begin{list}{}{%
  \setlength{\rightmargin}{0.5cm}
  \setlength{\leftmargin}{0.5cm}
  \small} 
  \item[] }
{\end{list}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\ps@headreport}
{ \renewcommand{\@oddhead}
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\begin{minipage}{2cm}
    \includegraphics[scale=.15]{enp2025.jpeg}
\end{minipage}
\hspace{2.3cm}
\begin{minipage}{10cm}
    \begin{center}
         {\bf \large II Encontro Nacional do PROFMAT}\\
      \vspace{0.5em}
        {\normalsize 15 a 18 de outubro de 2025, Campo Grande/MS}
    \end{center}
\end{minipage}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\vspace{0.2cm}
     \rule{\textwidth}{0.6pt} 
  \renewcommand{\@oddfoot}{}
  \renewcommand{\@evenhead}{\@oddhead}
  \renewcommand{\@evenfoot}{\@oddfoot}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\criartitulo{\par
  \begingroup
    \renewcommand\thefootnote{\@arabic\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 0em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
      
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@criartitulo

    \thispagestyle{headreport}\@thanks
     \endgroup
  \global\let\thanks\relax
  \global\let\criartitulo\relax
  \global\let\@criartitulo\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@criartitulo{%
  \newpage
  \null
  \vspace{-3em}%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
  \end{center}%
    \vskip 1.5em%
    {\normalsize
      \lineskip .5em%
      \begin{minipage}[b]{\textwidth}
        \@author
      \end{minipage}\par}%
    \vskip 1em%
    %{\large \@date}%
  \par
  \vskip 1em}
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\newcommand{\runningheads}{\markboth}
\pagestyle{myheadings}

\normalsize

\setcounter{page}{1}

\endinput
